//=============================================================================
// Gold.
//=============================================================================
class MH2_Pickup_Gold extends HealthVial;

#exec TEXTURE IMPORT NAME=GoldCoin  FILE=Textures\GoldCoin.bmp MIPS=ON

#exec mesh import mesh=Gold anivfile=Models\Gold_a.3d datafile=Models\Gold_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=Gold x=0 y=0 z=0
#exec mesh sequence mesh=Gold seq=All startframe=0 numframes=1

#exec meshmap new meshmap=Gold mesh=Gold
#exec meshmap scale meshmap=Gold x=0.02813 y=0.02813 z=0.05625

var() int GoldAmount;

event float BotDesireability(Pawn Bot)
{

	return (0); 

}

function PlayPickupMessage(Pawn Other)
{
	Other.ReceiveLocalizedMessage( class'PickupMessagePlus', 0, None, None, Self.Class );
}

auto state Pickup
{	
	function Touch( actor Other )
	{
		local int HealMax;
		
		if ( ValidTouch(Other) && Other.IsA('PlayerPawn')) 
			{
			
			Info_PRI(PlayerPawn(Other).PlayerReplicationInfo).GoldAmount += GoldAmount;

			PlayPickupMessage(PlayerPawn(Other));
			PlaySound (PickupSound,,2.5);
			Other.MakeNoise(0.2);		
			SetRespawn();	
			}
	

	}
}

defaultproperties
{
     GoldAmount=1
     PickupMessage="Your picked up 1 goldpiece"
     ItemName="Gold"
     RespawnTime=0.000000
     PickupViewMesh=Mesh'Gold'
     //PickupSound=Sound'AmbAncient.OneShot.bhit1'
     Mesh=Mesh'Gold'
     ScaleGlow=2.000000
     CollisionRadius=16.000000
     CollisionHeight=8
     bCollideWhenPlacing=True
     MultiSkins(0)=Texture'GoldCoin'

}
